//        
//,  1    
//+
//:    ,    .
//   
//1  ,    
//   
//   

// 
extern double TakeProfit = 15;
extern double Lots = 1.0;
extern double StopLoss = 20;
// :

extern bool   AllPositions   = False; //   
extern bool   ProfitTrailing = True;  //   
extern int    TrailingStop   = 10;    //   
extern int    TrailingStep   = 2;     //  
extern bool   UseSound       = False; //   
extern string NameFileSound  = "expert.wav";  //   



extern bool uplot = true; //- /   
extern int lastprofit = -1;// -   -1/1. 
//-1 -        .
//1 -        .
extern double lotmin = 0.1; //-  
extern double lotmax = 5;// - 
extern double lotstep = 2;// -   

//    
extern string StartTime = "08:00";
extern string EndTime = "23:00";




int prevBar;

void start() {
CheckForOpen();
}
void CheckForOpen() {
// 
double par0, par1, par2;
int res, total;
par0=iSAR(NULL,0,0.02,0.2,0);
par1=iSAR(NULL,0,0.02,0.2,1);
par2=iSAR(NULL,0,0.02,0.2,2);

//   
//   
if (TimeCheck()==False) return(0);
Lots=GetLots();
if (!ExistPosition() && prevBar!=Bars) {
 if (par1<Open[1] && par0>Ask)
     { 
      res=OrderSend(Symbol(),OP_SELL,Lots,Bid,4,Ask+StopLoss*Point,Ask-TakeProfit*Point,"",16384,0,Red);
            prevBar=Bars;
      
        } 
   else
//    
if  (par1>Open[1] && par0<Bid)
     { 
res=OrderSend(Symbol(),OP_BUY,Lots,Ask,4,Bid-StopLoss*Point,Bid+TakeProfit*Point,"",16384,0,Green);
        prevBar=Bars;
        
        }  
}
//if ((CurTime() - GetLastOpenTime(OP_BUY) <= 13*60) || (CurTime() - GetLastOpenTime(OP_SELL) <= 13*60))return(0);{
 {
 for (int i=0; i<OrdersTotal(); i++) {
    if (OrderSelect(i, SELECT_BY_POS, MODE_TRADES)) {
      if (AllPositions || OrderSymbol()==Symbol()) {
        TrailingPositions();
      }
    }
  }
 }
 
return(0);

}


//+------------------------------------------------------------------+
//|                                 |
//+------------------------------------------------------------------+
void TrailingPositions() {
  double pBid, pAsk, pp;

  pp = MarketInfo(OrderSymbol(), MODE_POINT);
  if (OrderType()==OP_BUY) {
    pBid = MarketInfo(OrderSymbol(), MODE_BID);
    if (!ProfitTrailing || (pBid-OrderOpenPrice())>TrailingStop*pp) {
      if (OrderStopLoss()<pBid-(TrailingStop+TrailingStep-1)*pp) {
        ModifyStopLoss(pBid-TrailingStop*pp);
        return;
      }
    }
  }
  if (OrderType()==OP_SELL) {
    pAsk = MarketInfo(OrderSymbol(), MODE_ASK);
    if (!ProfitTrailing || OrderOpenPrice()-pAsk>TrailingStop*pp) {
      if (OrderStopLoss()>pAsk+(TrailingStop+TrailingStep-1)*pp || OrderStopLoss()==0) {
        ModifyStopLoss(pAsk+TrailingStop*pp);
        return;
      }
    }
  }
}

//+------------------------------------------------------------------+
//|   StopLoss                                          |
//| :                                                       |
//|   ldStopLoss -  StopLoss                                  |
//+------------------------------------------------------------------+
void ModifyStopLoss(double ldStopLoss) {
  bool fm;

  fm=OrderModify(OrderTicket(),OrderOpenPrice(),ldStopLoss,OrderTakeProfit(),0,CLR_NONE);
  if (fm && UseSound) PlaySound(NameFileSound);
}


//+------------------------------------------------------------------+
// 
int GetLastOrderHist(int type = -1) 
{
  
  int ticket = -1;
  datetime dt = 0;
  int cnt = HistoryTotal();
    
  for (int i=0; i < cnt; i++) {
    if (!OrderSelect(i, SELECT_BY_POS, MODE_HISTORY)) continue;

    //
    if (OrderSymbol() != Symbol()) continue;
    //
//    if (OrderMagicNumber() != Magic) continue;
    
    if (type != -1 && OrderType() != type) continue;
    
    if (OrderCloseTime() > dt) {
      dt = OrderCloseTime();
     
      ticket = OrderTicket();
    }
  }
  
  return (ticket);
}


double GetLots() {
  
  double lot = lotmin;
  if (!uplot) return (lot);
  
  int ticket = GetLastOrderHist();
  if (ticket == -1) return (lot);
  
  if (!OrderSelect(ticket, SELECT_BY_TICKET, MODE_HISTORY)) return (lot);
  if (OrderProfit()*lastprofit < 0) {return (lot);}
  
  lot = MathMin(OrderLots() * lotstep, lotmax);
  return (lot);
}
//+------------------------------------------------------------------+
//|                                                   |
//+------------------------------------------------------------------+
bool TimeCheck() {
   if (TimeToStr(CurTime(),TIME_MINUTES)>=StartTime && TimeToStr(CurTime(),TIME_MINUTES)<=EndTime)  return (True);
   return (False);
   }


//+------------------------------------------------------------------+
//|                       |
//+------------------------------------------------------------------+
bool ExistPosition() {
  bool Exist=False;
  for (int i=0; i<OrdersTotal(); i++) {
    if (OrderSelect(i, SELECT_BY_POS, MODE_TRADES)) {
      if (OrderSymbol()==Symbol() /*&& OrderMagicNumber()==MAGIC*/) Exist=True;
    }
  }
  return(Exist);
}
/*
//=====================*GetLastOrderTime*===========
// 
datetime GetLastOpenTime(int type) {

  datetime tm = -1;

  int cnt = OrdersTotal();
  for (int i=0; i<cnt; i++) {
    if (!OrderSelect(i, SELECT_BY_POS, MODE_TRADES)) continue;
    
    //
    if (OrderSymbol() != Symbol()) continue;
   // if (OrderMagicNumber() != 16384) continue;
    
    if (OrderType() != type) continue;
    
    tm = MathMax(tm, OrderOpenTime());
  }

  cnt = HistoryTotal();
  for (i=0; i<cnt; i++) {
    if (!OrderSelect(i, SELECT_BY_POS, MODE_HISTORY)) continue;

    //
    if (OrderSymbol() != Symbol()) continue;
    //if (OrderMagicNumber() != 16384) continue;
    
    if (OrderType() != type) continue;
    
    tm = MathMax(tm, OrderOpenTime());
  }

  return (tm);
}

//===================

